using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using VIRP.EFR.BO;

namespace VIRP.EFR.DAL
{
	public partial class SPECIMEN_ANALYSISDB : DBUtils
	{
        #region Fields
        #endregion

        #region Constructors

        public SPECIMEN_ANALYSISDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public SPECIMEN_ANALYSIS GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 SPECIMEN_ANALYSIS_ID)
		{
			SPECIMEN_ANALYSIS objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_SPECIMEN_ANALYSIS_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, SPECIMEN_ANALYSIS_ID).FirstOrDefault();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public List<SPECIMEN_ANALYSIS> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
		{
			List<SPECIMEN_ANALYSIS> objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_SPECIMEN_ANALYSIS_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

        public List<SPECIMEN_ANALYSIS> GetItemsByActivity(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 WKF_CASE_ACTIVITY_ID)
        {
            List<SPECIMEN_ANALYSIS> objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_SPECIMEN_ANALYSIS_getitemsByActivity(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public int Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, SPECIMEN_ANALYSIS objSave)
		{
			Int32? objReturn = objSave.SPECIMEN_ANALYSIS_ID;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_SPECIMEN_ANALYSIS_save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave.ANALYTE_VOLUME_NUMBER, objSave.BSO_NUMBER, objSave.CREATED, objSave.CREATEDBY, objSave.LAB_NAME, objSave.LAB_ORDER_ID, objSave.LAB_REPORT_DATE, objSave.LAB_UID_NUMBER, objSave.RESULT_ACKNOWLEDGE_DATE, objSave.RESULT_ACKNOWLEDGE_FLAG, objSave.RESULT_REJECT_DATE, objSave.RESULT_REJECT_FLAG, ref objReturn, objSave.SPECIMEN_COLLECTION_DATE, objSave.TIME_ELAPSED_NUMBER, objSave.TOTAL_VOLUME_NUMBER, objSave.UPDATED, objSave.UPDATEDBY, objSave.WKF_CASE_ACTIVITY_ID);
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn.GetValueOrDefault();
		}

		public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 SPECIMEN_ANALYSIS_ID)
		{
			Boolean objReturn = false;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_SPECIMEN_ANALYSIS_delete(CURRENT_USER, CURRENT_REGISTRY_ID, SPECIMEN_ANALYSIS_ID);
					objReturn = true;
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		#endregion
	}
}
